<?php

namespace apexl\Io\modules\user\controllers;

use apexl\hashing\Hash;
use apexl\Io\exceptions\RecordNotFoundException;
use apexl\Io\includes\Controller;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\user\entities\PasswordReset;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\Request\ResetPasswordRequest;
use apexl\Io\services\HttpPaths;
use Exception;
use Psr\Http\Message\ResponseInterface;

final readonly class ResetPasswordController extends Controller
{
    /**
     * @throws Exception
     */
    public function __invoke(
        ResetPasswordRequest $request,
        ResponseInterface $response,
        HttpPaths $path,
        Hash $hash,
        RouteManager $routeManager,
    ): ResponseInterface {
        try {
            $reset = PasswordReset::fromHash($request->hash());

            if (!$reset->isUsable()) {
                $this->output->addMetadata(
                    'user.reset_password.validation.failed.refresh',
                    'refreshGlobal',
                    true,
                );

                $this->output->addMessage(
                    $path->getRouteName($request) . '.validation',
                    'error',
                    'Link expired'
                );

                return $this->json($response, status: 401);
            }

            $reset->markUsed();

            $user = userEntity::fromEmail($reset->email);

            $hashData = $hash->hashString($request->password());

            $passwordHash = $hashData->hash;
            $passwordSalt = $hashData->salt;

            $user->password = $passwordHash;
            $user->salt = $passwordSalt;
            $user->store();

            $this->output->addRedirect(
                'user.reset_password.validation.success.redirect',
                $routeManager->getRoutePattern('user.display.reset-password-success')
            );
            return $this->json($response);

        } catch (RecordNotFoundException) {
            $this->output->addMessage(
                $path->getRouteName($request) . '.validation',
                'error',
                'We were unable to reset your password'
            );

            return $this->throw404($response);
        }
    }
}
