<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Migration\AbstractMigration;

final class RemovePermissionsFromRolesTable extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function up(): void
    {
        $this->table('roles')
            ->removeColumn('permissions')
            ->update();
    }

    public function down(): void
    {
        $this->table('roles')
            ->addColumn('permissions', AdapterInterface::PHINX_TYPE_TEXT, ['null' => true])
            ->update();
    }
}
