<?php

namespace apexl\Io\modules\user\entities;

use apexl\entityCore\enums\Casts;
use apexl\entityCore\traits\hasCasts;
use apexl\Io\includes\Entity;
use apexl\Io\modules\user\entities\operators\sessionOperator;
use DateTimeImmutable;

/**
 * @property string $sessionId
 * @property int $uid
 * @property DateTimeImmutable $created
 * @property bool $ended
 * @property bool $active
 *
 * @mixin sessionOperator
 */
class sessionEntity extends Entity
{
    use hasCasts;

    private const string TABLE = 'sessions';
    private const string KEY = 'sessionId';

    public function __construct()
    {
        parent::__construct(self::TABLE, self::KEY);
        $this->setOperator(new sessionOperator(self::TABLE, self::KEY));
    }

    public function casts(): array
    {
        return [
            'uid' => Casts::INT,
            'created' => Casts::DATETIME_STAMP,
            'ended' => Casts::BOOL,
            'active' => Casts::BOOL,
        ];
    }
}
