<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Migration\AbstractMigration;

final class CreatePasswordReset extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('password_reset')
            ->addColumn('email', AdapterInterface::PHINX_TYPE_STRING, ['limit' => 120, 'null' => false])
            ->addColumn('hash', AdapterInterface::PHINX_TYPE_STRING, ['limit' => 256, 'null' => false])
            ->addColumn('created', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => false])
            ->addColumn('used', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => true])
            ->addIndex(['email'])
            ->addIndex(['hash'])
            ->create();
    }
}
