<?php

declare(strict_types=1);

use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\interfaces\newUserNotifier;
use apexl\Io\modules\user\notifiers\newUserEmailNotifier;
use function apexl\Io\container;

return [
    newUserNotifier::class =>
        fn(userEntity $user): newUserNotifier => container()->make(
            newUserEmailNotifier::class,
            ['user' => $user]
        ),
];
