<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\services;

use apexl\Io\modules\user\collections\userMetaCollection;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\entities\userMetaEntity;

class userMetaManagerService
{
    public function __construct(private userEntity $user)
    {
    }

    public function allMeta(): userMetaCollection
    {
        return userMetaEntity::forUser($this->user);
    }

    public function hasMeta(string $key): bool
    {
        return $this->meta($key) !== null;
    }

    public function meta(string $key): ?userMetaEntity
    {
        return userMetaEntity::forUserOfKey($this->user, $key);
    }

    public function removeMeta(string $key): void
    {
        $this->meta($key)?->delete();
    }

    public function addMeta($key, $value): void
    {
        $meta = $this->meta($key) ?? new userMetaEntity();
        $meta->meta_key = $key;
        $meta->meta_value = $value;
        $meta->user = $this->user->id;

        $meta->store();
    }

}
