<?php

declare(strict_types=1);

namespace apexl\Io\modules\userDisplay\Request;

use apexl\Io\modules\validation\Collections\ValidationRuleCollectionCollection;
use apexl\Io\modules\validation\Interfaces\HasValidationRulesInterface;
use apexl\Io\modules\validation\Interfaces\ValidatesDataInterface;
use apexl\Io\modules\validation\Traits\ValidatesData;
use apexl\Io\Request\IoRequest;

final class LoginDisplayRequest extends IoRequest implements ValidatesDataInterface
{
    use ValidatesData;

    public function redirect(): string
    {
        return $this->query('redirect', '/');
    }

    public function validationRules(): array|ValidationRuleCollectionCollection|HasValidationRulesInterface
    {
        return [
            'redirect' => 'nullable|email',
        ];
    }
}