<?php

declare(strict_types=1);

namespace apexl\Io\modules\userDisplay\controllers;

use apexl\Io\includes\RouteManager;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\controllers\DisplayController;
use apexl\Io\modules\userDisplay\FormBuilders\ResetPasswordFormBuilder;
use JsonException;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final readonly class ResetPasswordSuccessDisplayController extends DisplayController
{

    public function resetPasswordSuccess(ServerRequestInterface $request, ResponseInterface $response, $args): ResponseInterface
    {
        $this->render->setActive("noUI");
        $this->render->setPageTitle("Your password has been reset");

        $components = [
        ];

        $this->output->addResponse($request, $this->render->build($components));

        return $this->json($response);
    }

    /**
     * @throws JsonException
     */
    public function __invoke(
        ServerRequestInterface $request,
        ResponseInterface $response,
        ResetPasswordFormBuilder $formBuilder,
        RouteManager $routeManager,
    ): ResponseInterface {
        $this->render->setActive('noUI');
        $this->render->setPageTitle('Your password has been reset');

        $this->output->addResponse($request, $this->render->build([
            $this->component(ContentTitle::class)
                ->addTitle('Password reset successful')
                ->addContent('Please login to the site using your new credentials:')
                ->addClass('mb-5'),

            $this->component(BasicLink::class)
                ->addClass('btn btn-primary')
                ->addText('Go to login page')
                ->addRoute($routeManager->getRoutePattern('user.display.login'))
        ]));

        return $this->json($response);
    }

}


