<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Db\Table\ForeignKey;
use Phinx\Db\Table\Index;
use Phinx\Migration\AbstractMigration;

final class CreatePermissionsUsers extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('permissions__users')
            ->addColumn('permission', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('user', AdapterInterface::PHINX_TYPE_INTEGER, [
                'signed' => false,
                'null' => false,
            ])
            ->addIndex(['user', 'permission'], [
                Index::UNIQUE => true,
            ])
            ->addForeignKey('user', 'users', 'id', [
                'delete' => ForeignKey::CASCADE,
                'update' => ForeignKey::CASCADE,
            ])
            ->create();
    }
}
