<?php

declare(strict_types=1);

namespace apexl\Io\modules\userDisplay\FormBuilders;

use apexl\Io\includes\RouteManager;
use apexl\Io\modules\component\Collections\ComponentCollection;
use apexl\Io\modules\component\Factories\GenericComponentFactory;
use apexl\Io\modules\formbuilder\ComponentFactories\FormComponentFactory;
use apexl\Io\modules\formbuilder\ComponentFactories\FormFieldComponentFactory;
use apexl\Io\modules\formbuilder\Components\Form;
use apexl\Io\modules\formbuilder\Components\FormKitField\HiddenFormKitField;
use apexl\Io\modules\formbuilder\Components\FormKitField\PasswordFormKitField;
use apexl\Io\modules\formbuilder\FormBuilders\FormBuilder;
use apexl\Io\modules\formbuilder\FormKitValidation\ValidationRule;
use apexl\Io\services\VariableManager;

readonly class ResetPasswordFormBuilder extends FormBuilder
{
    public function __construct(
        private VariableManager $variableManager,
        FormFieldComponentFactory $fieldComponentFactory,
        GenericComponentFactory $componentFactory,
        RouteManager $routeManager,
        FormComponentFactory $formComponentFactory,
        string $formClass = Form::class
    ) {
        parent::__construct(
            $fieldComponentFactory,
            $componentFactory,
            $routeManager,
            $formComponentFactory,
            $formClass
        );
    }

    protected function init(): void
    {
        parent::init();

        $this->form->setTitle('Reset your password using the form below.')
            ->addClass('forgotten-password-form')
            ->setSubmitText('Reset Password Now');
    }

    protected function formAction(): string
    {
        return $this->routeManager->getRoutePattern('user.resetPassword');
    }

    protected function components(ComponentCollection $components): ComponentCollection
    {
        $components->add(
            $this->field(PasswordFormKitField::class, 'password')
                ->setLabel('Password')
                ->setPlaceholder('Password')
                ->addValidation(ValidationRule::charLength(6))
                ->setHelp('Min 6 characters')
                ->hideLabel()
                ->isRequired()
        );

        $components->add(
            $this->field(PasswordFormKitField::class, 'password_confirm')
                ->setLabel('Confirm Password')
                ->setPlaceholder('Confirm Password')
                ->addValidation(ValidationRule::charLength(6))
                ->addValidation(ValidationRule::confirm())
                ->hideLabel()
                ->isRequired()
        );

        $components->add(
            $this->field(HiddenFormKitField::class, 'hash')
                ->isRequired(),
        );

        return $components;
    }
}


