<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\services;

use apexl\Io\modules\user\entities\RefreshToken;

final class RefreshTokenCreator
{
    public function create(int $userId): RefreshToken
    {
        $refreshToken = bin2hex(random_bytes(20));

        $refreshTokenEntity = new RefreshToken();
        $refreshTokenEntity->load($userId);
        $refreshTokenEntity->user_id = $userId;
        $refreshTokenEntity->token = $refreshToken;
        $refreshTokenEntity->expiry = RefreshToken::newExpiryFrom();
        $refreshTokenEntity->store();

        return $refreshTokenEntity;
    }

}
