<?php

declare(strict_types=1);

namespace apexl\Io\modules\userDisplay\FormBuilders;

use apexl\Io\includes\RouteManager;
use apexl\Io\modules\component\Collections\ComponentCollection;
use apexl\Io\modules\component\Factories\GenericComponentFactory;
use apexl\Io\modules\formbuilder\ComponentFactories\FormComponentFactory;
use apexl\Io\modules\formbuilder\ComponentFactories\FormFieldComponentFactory;
use apexl\Io\modules\formbuilder\Components\Form;
use apexl\Io\modules\formbuilder\Components\FormKitField\EmailFormKitField;
use apexl\Io\modules\formbuilder\FormBuilders\FormBuilder;
use apexl\Io\services\VariableManager;

readonly class ForgotPasswordFormBuilder extends FormBuilder
{
    public function __construct(
        private VariableManager $variableManager,
        FormFieldComponentFactory $fieldComponentFactory,
        GenericComponentFactory $componentFactory,
        RouteManager $routeManager,
        FormComponentFactory $formComponentFactory,
        string $formClass = Form::class
    ) {
        parent::__construct(
            $fieldComponentFactory,
            $componentFactory,
            $routeManager,
            $formComponentFactory,
            $formClass
        );
    }

    protected function init(): void
    {
        parent::init();

        $this->form->setTitle('Enter your email to reset your password.')
            ->addClass('forgotten-password-form')
            ->setSubmitText('Get Reset Link');
    }

    protected function formAction(): string
    {
        return $this->routeManager->getRoutePattern('user.forgot-password');
    }

    protected function components(ComponentCollection $components): ComponentCollection
    {
        $components->add(
            $this->field(EmailFormKitField::class, 'email')
                ->setPlaceholder(
                    $this->variableManager->get('user_login_email_placeholder') ?? 'Enter your email address'
                )
                ->setLabel('Email Address')
                ->hideLabel()
                ->isRequired()
        );

        return $components;
    }
}


