<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\notifiers;

use apexl\Config\Singleton as Config;
use apexl\Io\modules\email\services\TemplateService;
use apexl\Io\modules\notifier\interfaces\emailNotifierDriverInterface;
use apexl\Io\modules\notifier\notifiers\emailNotifier;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\interfaces\newUserNotifier;
use Exception;

final class newUserEmailNotifier extends emailNotifier implements newUserNotifier
{
    public function __construct(
        emailNotifierDriverInterface $driver,
        private readonly userEntity $user,
        private readonly TemplateService $templateService
    ) {
        parent::__construct($driver);
    }

    protected function to(): string
    {
        return $this->user->email;
    }

    protected function subject(): string
    {
        return 'Welcome to the Tile Designer!';
    }

    /**
     * @throws Exception
     */
    protected function body(): string
    {
        return $this->templateService->fetch('new_user', [
            'name' => $this->user->first_name,
            'domain' => config('app.site.frontend_domain'),
        ]);
    }
}
