<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\traits;

trait Appends
{
    public final const int FLAG_URL = 1;

    protected function append(string $base, string $append = '', $flags = self::FLAG_URL): string
    {
        if ($flags & self::FLAG_URL) {
            $append = ltrim($append, '/');
        }

        return sprintf(
            '%s%s',
            $base,
            $append ? sprintf('%s%s', '/', $append) : ''
        );
    }

}