<?php

namespace apexl\Io\modules\userDisplay\components;

use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\display\components\genericComponents;

class dataTables
{
    public static function userTableShortlist($filters = '')
    {
        return self::DataTableDisplayTile(
            $this->routeManager->getRoutePattern('userEntity.get') . $filters,
            $this->routeManager->getRoutePattern('userEntity.all'),
            'UpdateUsers',
            'DeleteUsers'
        );
    }

    public static function DataTableDisplayTile($dataSrc, $buttonRoute, $editRole = false, $deleteRole = false): componentEntity
    {
        $currentUser = $this->currentUserFactory->get();
        $table = genericComponents::dataTable($dataSrc);
        if ($access = ($editRole ? $currentUser->isAllowed($editRole) : true)) {
            $processButton = genericComponents::tableButton(
                $buttonRoute,
                'edit',
                '',
                'btn table__btn table__btn-edit',
                'edit'
            );
            $table->addComponent($processButton);
        }
        if ($access = ($deleteRole ? $currentUser->isAllowed($deleteRole) : true)) {
            $deleteButton = genericComponents::tableButton(
                $buttonRoute,
                'trash-alt',
                '',
                'btn table__btn table__btn-delete',
                'delete'
            );
            $table->addComponent($deleteButton);
        }

        return $table;
    }

    public static function userRoleShortlist($filters = '')
    {
        return self::DataTableDisplayTile(
            $this->routeManager->getRoutePattern('roleEntity.get') . $filters,
            $this->routeManager->getRoutePattern('roleEntity.all'),
            'CreateRoles',
            'DeleteRoles'
        );
    }
}
