<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\Factories;

use apexl\Io\modules\user\services\JwtFromRequestService;
use DI\Container;
use Psr\Http\Message\ServerRequestInterface;

final readonly class JwtFromRequestServiceFactory
{
    public function __construct(private Container $container) {}

    public function make(ServerRequestInterface $request): JwtFromRequestService
    {
        return $this->container->make(JwtFromRequestService::class, [
            'request' => $request,
        ]);
    }

}
