<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\services;

use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\services\GlobalData;

final readonly class CurrentUserFactory
{
    public function __construct(private GlobalData $globalData) {}

    public function get(): ?userEntity
    {
        $entities = $this->globalData->getData('entities');

        return $entities['user']['entity'] ?? null;
    }

}
