<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\services;

use apexl\Io\exceptions\RecordNotFoundException;
use apexl\Io\modules\user\entities\RefreshToken;
use apexl\Io\modules\user\exceptions\RefreshTokenExpiredException;

final readonly class RefreshTokenEntityFinder
{
    /**
     * @throws RefreshTokenExpiredException
     * @throws RecordNotFoundException
     */
    public function fromToken(string $token): RefreshToken
    {
        $refreshTokenEntity = RefreshToken::fromToken($token);

        if ($refreshTokenEntity->isExpired()) {
            throw new RefreshTokenExpiredException('Token expired');
        }

        return $refreshTokenEntity;
    }
}