<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\RequestHelper;

use apexl\Io\exceptions\ValidationException;
use apexl\Io\requestHelper\requestHelper;

final readonly class LoginRequestHelper extends RequestHelper
{
    /**
     * @throws ValidationException
     */
    public function validate(): void
    {
        $this->requireBody('username', 'Please provide a username');
        $this->requireBody('password', 'Please provide an password address');
    }

    public function username(): string
    {
        return $this->bodyParam('username', '');
    }

    public function password(): string
    {
        return $this->bodyParam('password', '');
    }

    public function redirect(): ?string
    {
        return $this->bodyParam('redirect', '');
    }
}
