<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\hooks;

use apexl\Io\includes\System;
use apexl\Io\interfaces\AbstractHook;
use apexl\Io\modules\notifier\exceptions\notifierException;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\interfaces\newUserNotifier;
use Exception;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

final readonly class SendNewUserNotification implements AbstractHook
{

    public function hooks(): array
    {
        return ['userPostSave'];
    }

    /**
     * @throws ContainerExceptionInterface
     * @throws NotFoundExceptionInterface
     * @throws notifierException
     * @throws Exception
     */
    public function __invoke(userEntity $user): userEntity
    {
        if (config('user.sendNewUserNotification')) {
            $notifier = System::makeRegisteredService(newUserNotifier::class, [
                'user' => $user,
            ]);

            $notifier->send();
        }

        return $user;
    }
}
