<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\entities;

use apexl\entityCore\enums\Casts;
use apexl\entityCore\traits\hasCasts;
use apexl\Io\includes\Entity;
use DateTimeImmutable;
use function apexl\Io\config;

/**
 * @property int $id
 * @property string $email
 * @property string $hash
 * @property DateTimeImmutable $created
 * @property bool $used
 */
class PasswordReset extends Entity
{
    use hasCasts;

    final public const string TABLE = 'password_reset';

    public function __construct($table = '', $primaryKey = 'id', $extends = null)
    {
        parent::__construct(self::TABLE, $primaryKey, $extends);
    }

    public function casts(): array
    {
        return [
            'id' => Casts::INT,
            'created' => Casts::DATETIME_STAMP,
            'used' => Casts::BOOL,
        ];
    }

    public function markUsed(): void
    {
        $this->used = true;
        $this->store();
    }

    public function isExpired(): bool
    {
        return (time() - $this->created->getTimestamp()) <= config('auth.reset_password_lifetime');
    }
}