<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\services;

use apexl\Io\exceptions\RecordNotFoundException;
use PasswordReset;

final readonly class ForgotPasswordLinkService
{
    public function create(string $email, string $hash): void
    {
        $passwordReset = new PasswordReset();

        $passwordReset->email = $email;
        $passwordReset->hash = $hash;
        $passwordReset->created = time();
        $passwordReset->used = false;
        $passwordReset->store();
    }

    /**
     * @throws RecordNotFoundException
     */
    public function get(string $hash): PasswordReset
    {
        return PasswordReset::from('hash', $hash);
    }
}