<?php

/** @noinspection PhpUnused */

namespace apexl\Io\modules\userDisplay;

use apexl\Io\enums\HttpMethod;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\display\controllers\displayController;
use apexl\Io\modules\menu\interfaces\ProvidesMenuItemsInterface;
use apexl\Io\modules\menu\services\MenuManager;
use apexl\Io\modules\system\interfaces\ProvidesRoutesInterface;
use apexl\Io\modules\user\classes\userManagedDisplayModule;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\enums\permissions\Common;
use apexl\Io\modules\user\enums\permissions\Role;
use apexl\Io\modules\user\enums\permissions\User;
use apexl\Io\modules\userDisplay\controllers\ForgotPasswordDisplayController;
use apexl\Io\modules\userDisplay\controllers\LoginDisplayController;
use apexl\Io\modules\userDisplay\controllers\rolesController;
use apexl\Io\modules\userDisplay\controllers\userController;
use apexl\Io\modules\userDisplay\forms\filters;
use apexl\Io\modules\userDisplay\hooks\RegisterRedirects;
use app\vendor\apexl\io\src\Io\interfaces\ProvidesHooksInterface;

class userDisplayModule extends userManagedDisplayModule implements ProvidesHooksInterface, ProvidesMenuItemsInterface, ProvidesRoutesInterface
{
    public function routes(RouteManager $routeManager): void
    {
        //Page routes.
        $this->addProtectedRootRoute(
            $routeManager,
            HttpMethod::GET,
            'user.display.login.nfc',
            'login/nfc',
            userController::class . ':loginNfcPage'
        );
        $this->addProtectedRootRoute(
            $routeManager,
            HttpMethod::GET,
            'user.display.login',
            'login[/{loginMessageType}]',
            LoginDisplayController::class
        );
        $this->addProtectedRootRoute(
            $routeManager,
            HttpMethod::GET,
            'user.display.register',
            'register',
            userController::class . ':registerPage'
        );

        $this->addProtectedRootRoute(
            $routeManager,
            HttpMethod::GET,
            'user.display.forgot-password',
            'forgot-password',
            ForgotPasswordDisplayController::class
        );
        
        $this->addProtectedRootRoute(
            $routeManager,
            HttpMethod::GET,
            'user.display.forgot-password.check-email',
            'forgot-password/check-email',
            userController::class . ':forgotPasswordCheckEmail'
        );
        $this->addProtectedRootRoute(
            $routeManager,
            HttpMethod::GET,
            'user.display.settings',
            'user/settings',
            userController::class . ':userSettingsPage',
            Common::IS_LOGGED_IN
        );
        $this->addProtectedRootRoute(
            $routeManager,
            HttpMethod::GET,
            'user.display.dashboard',
            'users',
            userController::class . ':userHome',
            Common::IS_LOGGED_IN
        );

        //These are display routes, so in this instance VERBS are used to dictate the pattern, NOT the HTTP verb.
        $this->addProtectedEntityRoutes(
            $routeManager,
            (new userEntity()),
            [
                'all' => [userController::class . ':userList', User::VIEW],
                'get' => [userController::class . ':userViewSingle', User::VIEW],
                'put' => [userController::class . ':updateView', User::UPDATE],
                'post' => [userController::class . ':create', User::CREATE],
                'delete' => [displayController::class . ':delete', User::DELETE],
            ]
        );

        $this->addProtectedEntityRoutes(
            $routeManager,
            (new roleEntity()),
            [
                'all' => [rolesController::class . ':roleList', Role::VIEW],
                'get' => [rolesController::class . ':view', Role::VIEW],
                'put' => [rolesController::class . ':updateView', Role::UPDATE],
                'post' => [rolesController::class . ':create', Role::CREATE],
                'delete' => [displayController::class . ':delete', Role::DELETE],
            ]
        );

        //data routes
        $this->addProtectedDataRoute(
            $routeManager,
            HttpMethod::GET,
            'userEntity.data.summery',
            'user-summery',
            userController::class . ':userSummery',
            User::VIEW
        );
        $this->addProtectedDataRoute(
            $routeManager,
            HttpMethod::GET,
            'roleEntity.data.summery',
            'role-summery',
            rolesController::class . ':roleSummery',
            Role::VIEW
        );

        //Forms - Users
        $this->addProtectedFormRoute(
            $routeManager,
            'user.display.forms.login',
            'loginForm[/{redirectToRoute}]',
            userController::class . ':loginForm'
        );
        $this->addProtectedFormRoute(
            $routeManager,
            'user.display.forms.forgottenPassword',
            'forgottenPasswordForm',
            userController::class . ':forgotPasswordForm'
        );
        $this->addProtectedFormRoute(
            $routeManager,
            'user.display.forms.resetPassword',
            'resetPasswordForm/{hash}',
            userController::class . ':resetPasswordForm'
        );
        $this->addProtectedFormRoute(
            $routeManager,
            'user.display.forms.register',
            'registerForm',
            userController::class . ':registerForm'
        );
        $this->addProtectedFormRoute(
            $routeManager,
            'user.display.forms.userSettings',
            'userSettings',
            userController::class . ':userSettingsForm',
            Common::IS_LOGGED_IN
        );
        $this->addProtectedFormRoute(
            $routeManager,
            'user.display.forms.createUpdate',
            'userCreate[/{id}]',
            userController::class . ':userEditForm',
            User::CREATE
        );
        $this->addProtectedFormRoute(
            $routeManager,
            'user.display.forms.loginAsUser',
            'loginAsUserForm/{userId}',
            userController::class . ':loginAsUserForm',
            User::MANAGE
        );
        $this->addProtectedFormRoute(
            $routeManager,
            'user.display.forms.createNote',
            'create-user-note/{userId}',
            userNoteController::class . ':createNoteForm',
            User::UPDATE
        );

        //Forms - Roles
        $this->addProtectedFormRoute(
            $routeManager,
            'role.display.forms.createUpdate',
            'roleCreate[/{id}]',
            rolesController::class . ':manageForm',
            Role::CREATE
        );

        //Filter forms
        $this->addProtectedFormRoute(
            $routeManager,
            'user.display.forms.filters.userFilter',
            'user-filter',
            filters::class . ':userFilter',
            User::VIEW
        );

        $this->addProtectedRootRoute(
            $routeManager,
            HttpMethod::GET,
            'user.display.reset-password',
            'reset-password/{hash}',
            userController::class . ':resetPasswordPage'
        );

        $this->addProtectedRootRoute(
            $routeManager,
            HttpMethod::GET,
            'user.display.reset-password-success',
            'reset-password-success',
            userController::class . ':resetPasswordSuccess'
        );
    }

    public function menuItems(MenuManager $menuManager): void
    {
        // Navigation Menu
        $menuManager->addToMenu('home', [
            'title' => 'Home',
            'icon' => 'home',
            'weight' => -10,
        ]);

        //Administration menu
        $menuManager->addToMenu('user.admin', [
            'title' => 'Users',
            'icon' => 'users',
            'weight' => 0,
        ], 'administration');

        $menuManager->addToMenu('user.display.dashboard', [
            'title' => 'Overview',
            'weight' => -10,
            'parent' => 'user.admin',
            'icon' => 'user-chart',
        ], 'administration');

        $menuManager->addToMenu('userEntity.display.all', [
            'title' => 'View all users',
            'weight' => -9,
            'parent' => 'user.admin',
            'icon' => 'users',
        ], 'administration');

        $menuManager->addToMenu('userEntity.display.post', [
            'title' => 'Create a user',
            'weight' => -8,
            'parent' => 'user.admin',
            'icon' => 'users-medical',
        ], 'administration');

        $menuManager->addToMenu('roleEntity.display.all', [
            'title' => 'View all roles',
            'weight' => -9,
            'parent' => 'user.admin',
            'icon' => 'user-secret',
        ], 'administration');

        $menuManager->addToMenu('roleEntity.display.post', [
            'title' => 'Create a role',
            'weight' => -8,
            'parent' => 'user.admin',
            'icon' => 'user-unlock',
        ], 'administration');
    }

    public function hooks(): array
    {
        return [
            RegisterRedirects::class,
        ];
    }
}
