<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\RequestHelper;

use apexl\Io\exceptions\ValidationException;
use apexl\Io\requestHelper\requestHelper;

final readonly class ForgotPasswordRequestHelper extends RequestHelper
{
    /**
     * @throws ValidationException
     */
    public function validate(): void
    {
        $this->requireBody('email', 'Please provide an email address');

        if (!filter_var($this->email(), FILTER_VALIDATE_EMAIL)) {
            throw new ValidationException('Please provide valid email address');
        }
    }

    public function email(): string
    {
        return $this->bodyParam('email');
    }
}
