<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\RequestHelper;

use apexl\Io\requestHelper\requestHelper;

final readonly class LoginByKeyRequestHelper extends requestHelper
{
    public function nfcKey(): string
    {
        return $this->bodyParam('nfc_key');
    }

    public function redirect(): ?string
    {
        return $this->bodyParam('redirect');
    }

    public function validate(): void
    {
        $this->requireBody('nfc_key');
    }
}