<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\RequestHelper;

use apexl\Io\requestHelper\requestHelper;

final readonly class ResetPasswordRequestHelper extends RequestHelper
{
    public function hash(): string
    {
        return $this->bodyParam('hash');
    }

    public function validate(): void
    {
        $this->requireBody('hash');
        $this->requireBody('password');
        $this->requireBody('password_confirm');

        $this->validateSame('password', 'password_confirm');
    }

    public function password(): string
    {
        return $this->bodyParam('password');
    }

    public function passwordConfirm(): string
    {
        return $this->bodyParam('password_confirm');
    }

}