<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\notifiers;

use apexl\Io\modules\notifier\interfaces\emailNotifierDriverInterface;
use apexl\Io\modules\notifier\notifiers\emailNotifier;
use apexl\Io\modules\template\Services\TemplateService;
use apexl\Io\modules\user\entities\userEntity;
use Exception;

final class ResetPasswordEmailNotifier extends emailNotifier
{
    public function __construct(
        emailNotifierDriverInterface $driver,
        private readonly TemplateService $templateService,
        private readonly userEntity $user,
        private readonly string $link,
    ) {
        parent::__construct($driver);
    }

    protected function to(): string
    {
        return $this->user->email;
    }

    protected function subject(): string
    {
        return 'Password Reset Request';
    }

    /**
     * @throws Exception
     */
    protected function body(): string
    {
        return $this->templateService->template('email/password_reset', [
            'reset_link' => $this->link,
            'name' => $this->user->first_name,
        ]);
    }
}
