<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\services;

use apexl\Io\modules\user\exceptions\ClientCredentialsValidationException;
use function apexl\Io\config;

readonly final class ClientCredentialValidator
{
    /**
     * @throws ClientCredentialsValidationException
     */
    public function assertValid(string $clientId, string $clientSecret): void
    {
        if (
            ($clientId !== config('auth.client_id')) ||
            ($clientSecret !== config('auth.client_secret'))
        ) {
            throw new ClientCredentialsValidationException();
        }
    }
}
