<?php

declare(strict_types=1);

namespace apexl\Io\modules\userDisplay\FormBuilders;

use apexl\Io\includes\RouteManager;
use apexl\Io\modules\component\Collections\ComponentCollection;
use apexl\Io\modules\component\Factories\GenericComponentFactory;
use apexl\Io\modules\formbuilder\ComponentFactories\FormComponentFactory;
use apexl\Io\modules\formbuilder\ComponentFactories\FormFieldComponentFactory;
use apexl\Io\modules\formbuilder\Components\Form;
use apexl\Io\modules\formbuilder\Components\FormKitField\EmailFormKitField;
use apexl\Io\modules\formbuilder\Components\FormKitField\HiddenFormKitField;
use apexl\Io\modules\formbuilder\Components\FormKitField\PasswordFormKitField;
use apexl\Io\modules\formbuilder\FormBuilders\FormBuilder;
use apexl\Io\services\VariableManager;

readonly class LoginFormBuilder extends FormBuilder
{
    public function __construct(
        private VariableManager $variableManager,
        FormFieldComponentFactory $fieldComponentFactory,
        GenericComponentFactory $componentFactory,
        RouteManager $routeManager,
        FormComponentFactory $formComponentFactory,
        string $formClass = Form::class
    ) {
        parent::__construct(
            $fieldComponentFactory,
            $componentFactory,
            $routeManager,
            $formComponentFactory,
            $formClass
        );
    }

    protected function init(): void
    {
        parent::init();
        $this->form
            ->setTitle($this->variableManager->get('user_login_description_text') ?? 'Sign in with your email address.')
            ->setSubmitText($this->variableManager->get('user_login_submit_text') ?? 'Sign in')
            ->addClass('login-form');

        if ($this->variableManager->get('user_login_include_clear_button') ?? true) {
            $this->form->includeClearButton()->setClearButtonText(
                $this->variableManager->get('user_login_include_clear_button_text') ?? 'Cancel'
            );
        }
    }

    protected function formAction(): string
    {
        return $this->routeManager->getRoutePattern('user.login');
    }

    protected function components(ComponentCollection $components): ComponentCollection
    {
        $components->add($this->field(HiddenFormKitField::class, 'redirect'));

        $components->add(
            $this->field(EmailFormKitField::class, 'username')
                ->setPlaceholder(
                    $this->variableManager->get('user_login_email_placeholder') ?? 'Enter your email address'
                )
                ->setLabel('Email')
                ->hideLabel()
                ->isRequired()
        );

        $components->add(
            $this->field(PasswordFormKitField::class, 'password')
                ->setPlaceholder(
                    $this->variableManager->get('user_login_password_placeholder') ?? 'Enter your password'
                )
                ->setLabel('Password')
                ->hideLabel()
                ->isRequired()
        );

        return $components;
    }
}


