<?php

declare(strict_types=1);

namespace apexl\Io\modules\userDisplay\controllers;

use apexl\Io\includes\RouteManager;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\controllers\DisplayController;
use apexl\Io\services\VariableManager;
use JsonException;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final readonly class ForgotPasswordCheckEmailDisplayController extends DisplayController
{

    /**
     * @throws JsonException
     */
    public function __invoke(
        ServerRequestInterface $request,
        ResponseInterface $response,
        RouteManager $routeManager,
        VariableManager $variableManager,
    ): ResponseInterface {
        $this->render->setActive("noUI");
        $this->render->setPageTitle("Check Email");

        $this->output->addResponse($request, $this->render->build([
            $this->component(ContentTitle::class)
                ->addContent(
                    "Please check your email for further instructions. The email may take upto a few minutes to arrive."
                )
                ->addClass('col-md-12'),

            $this->component(BasicLink::class)
                ->addClass('forgottenPasswordLink')
                ->addRoute($routeManager->getRoutePattern('user.display.login'))
                ->addText($variableManager->get('user_login_return_login_text') ?? 'Return to login'),
        ]));

        return $this->json($response);
    }
}


