<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\Actions;

use apexl\hashing\Hash;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\notifier\exceptions\notifierException;
use apexl\Io\modules\notifier\factories\NotifierFactory;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\notifiers\ResetPasswordEmailNotifier;
use apexl\Io\modules\user\services\ForgotPasswordLinkService;
use function apexl\Io\config;

final readonly class ForgotPasswordAction
{
    public function __construct(
        private NotifierFactory $notifierFactory,
        private ForgotPasswordLinkService $forgotPasswordLinkService,
        private RouteManager $routeManager,
        private Hash $hash,
    ) {}

    /**
     * @throws notifierException
     */
    public function handle(userEntity $user): void
    {
        $this->notifierFactory->make(ResetPasswordEmailNotifier::class, [
            'user' => $user,
            'link' => $this->link($user),
        ])->send();
    }

    private function link(userEntity $user): string
    {
        //we do this so the has can be passed back as a url param rather than a query string.
        $randomHash = str_replace('/', '@', $this->hash->generateRandomHash());
        //write the hash to the database
        $this->forgotPasswordLinkService->create($user->email, $randomHash);

        return sprintf(
            '%s/%s',
            config('app.site.frontend_domain'),
            ltrim($this->routeManager->getRoutePattern('user.display.reset-password', ['hash' => $randomHash]), '/')
        );
    }
}