<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\Request;

use apexl\Io\modules\userDisplay\FormBuilders\ResetPasswordFormBuilder;
use apexl\Io\modules\validation\Interfaces\HasValidationRulesInterface;
use apexl\Io\modules\validation\Interfaces\ValidatesDataInterface;
use apexl\Io\modules\validation\Traits\ValidatesData;
use apexl\Io\Request\IoRequest;
use Psr\Http\Message\StreamInterface;
use Psr\Http\Message\UriInterface;
use Slim\Psr7\Interfaces\HeadersInterface;

final class ResetPasswordRequest extends IoRequest implements ValidatesDataInterface
{
    use ValidatesData;

    public function __construct(
        $method,
        UriInterface $uri,
        HeadersInterface $headers,
        array $cookies,
        array $serverParams,
        StreamInterface $body,
        array $uploadedFiles,
        private readonly ResetPasswordFormBuilder $formBuilder,
    ) {
        parent::__construct($method, $uri, $headers, $cookies, $serverParams, $body, $uploadedFiles);
    }

    public function hash(): string
    {
        return $this->bodyParam('hash');
    }

    public function password(): string
    {
        return $this->bodyParam('password');
    }

    public function passwordConfirm(): string
    {
        return $this->bodyParam('password_confirm');
    }

    public function validationRules(): HasValidationRulesInterface
    {
        return $this->formBuilder;
    }
}