<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Migration\AbstractMigration;

final class CreateRoles extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('roles')
            ->addColumn('name', AdapterInterface::PHINX_TYPE_STRING, ['limit' => 120, 'null' => false])
            ->addColumn('permissions', AdapterInterface::PHINX_TYPE_TEXT, ['null' => true])
            ->addColumn('created', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => true])
            ->addColumn('created_by', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => true])
            ->addColumn('modified', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => true])
            ->addColumn('modified_by', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => true])
            ->addIndex(['name'])
            ->addIndex(['created'])
            ->addIndex(['created_by'])
            ->addIndex(['modified'])
            ->addIndex(['modified_by'])
            ->create();
    }

}
