<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\enums\permissions;

use apexl\Io\modules\user\interfaces\PermissionInterface;
use apexl\Io\modules\user\traits\IsPermissionTrait;

enum Common implements PermissionInterface, \JsonSerializable
{
    use IsPermissionTrait;
    //in the case of CRUD permissions, these are a security placeholder and should not be directly implemented by modules. Instead, they are a fallback for routes generated with the IO-Basic module.
    case BYPASS;
    case CAN_DO_NOTHING;
    case ALLOW_ALL;
    case IS_LOGGED_IN;
    case VIEW;
    case CREATE;
    case UPDATE;
    case DELETE;
}
