<?php

declare(strict_types=1);

namespace apexl\Io\modules\user\hooks;

use apexl\Io\interfaces\AbstractHook;
use apexl\Io\modules\system\collections\MiddlewareCollectionCollection;
use apexl\Io\modules\system\services\MiddlewareCollector;
use apexl\Io\modules\user\Middleware\PermissionMiddleware;
use apexl\Io\modules\user\Middleware\SessionMiddleware;

final readonly class AddMiddleware implements AbstractHook
{
    public function hooks(): array
    {
        return [MiddlewareCollector::HOOK__COLLECT];
    }

    public function __invoke(MiddlewareCollectionCollection $weightedMiddleware): MiddlewareCollectionCollection
    {
        $weightedMiddleware->add(SessionMiddleware::class);
        $weightedMiddleware->add(PermissionMiddleware::class);

        return $weightedMiddleware;
    }
}
