<?php

namespace apexl\Io\modules\userDisplay\callbacks;

use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;

class tableRowAlters
{
    /**
     * A field callback for the getEntityData method.
     * @param $key
     * @param $entityId
     * @param $row
     * @return string
     */
    public static function userShortTable($key, $entityId, $row)
    {
        //switch on the provided key so we know what we're working with
        $entity = new userEntity();
        $entity->load($entityId);
        if ($key == 'field__first_name') {
            return $row['first_name'] . ' ' . $row['last_name'];
        }
        return '';
    }

    public static function roleShortTable($key, $entityId, $row)
    {
        //switch on the provided key so we know what we're working with
        $entity = new roleEntity();
        $entity->load($entityId);

        switch($key) {
            case 'field__created_by':
                $user = new userEntity();
                $user->load($row['created_by']);
                return $user->getNiceName();
            case 'field__permissions':
                $perms = explode(',',$row['permissions']);
                return count($perms);
        }
        return '';
    }
}
