<?php

namespace apexl\Io\modules\user\callbacks;
//dynamic permissions. We need to loop over all known roles and create an "assign role" permission.
use apexl\Io\includes\System;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\services\Permissions;

class callbacks{
    public static function postAuth(){
        if(!System::$installing) {
            $permissions = Permissions::getInstance();
            //dynamic permissions. We need to loop over all known roles and create an "assign role" permission.
            $roleEntity = new roleEntity();
            $roles = $roleEntity->loadMultiple();
            if (!empty($roles)) {
                foreach ($roles as $role) {
                    $permissions->registerPermission('AssignRole_' . $role->id, 'Assign Role: ' . $role->name,
                        'Assign Roles');
                }
            }
        }
    }
}
