<?php

namespace apexl\Io\modules\user\entities;

use apexl\Io\includes\Entity;
use apexl\Io\modules\user\entities\operators\roleOperator;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\operators\entityDatabaseOperator;

class roleEntity extends Entity {

    public function __construct()
    {
        parent::__construct('roles');
        $this->setOperator(new roleOperator('roles', 'id'));
    }

    public function getEntityType(): string
    {
        return __CLASS__;
    }

    public function access($permission): bool
    {
        $currentUser = currentUser::getCurrentUser();
        //are we logged in? if so, check if the permission is 'IsLoggedIn' and pass it if it is.
        if($currentUser->id != 0 && $permission == 'IsLoggedIn'){
            return TRUE;
        }

        if(is_array($this->permissions)) {
            return in_array($permission, $this->permissions);
        }
        return FALSE;
    }

    /**
     * override the magic load method, so we can intercept permissions and unserilize them.
     * @param $id
     * @param bool $skipAccessControl
     * @return $this
     *@throws \Exception
     */
    public function load($id, bool $skipAccessControl = FALSE): Entity
    {
        parent::__call('load', [$id, $skipAccessControl]);
        //gives us an array of role id's for easy use later.
        if (!empty($this->permissions) && is_string($this->permissions)) {
            $this->permissions = unserialize($this->permissions);
        }
        return $this;
    }

    /**
     * override the magic store method to make sure we serialise permission data before saving.
     * @throws \Exception
     */
    public function store(): Entity
    {
        //we need to revert the serialised data after storing, so its still available as if we loaded the data
        if(isset($this->permissions) && !empty($this->permissions) && is_array($this->permissions)){
            $cleanVersion = $this->permissions;
            $this->permissions = serialize($this->permissions);
            parent::__call('store', [$this->data]);
            $this->permissions = $cleanVersion;
            return $this;
        }
        parent::__call('store', [$this->data]);
        return $this;
    }
}