<?php

namespace apexl\Io\modules\userDisplay\forms;

use apexl\Io\includes\Routes;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\linkField;

class forgottenPasswordForm {
    public function forgottenPasswordForm() {
        $form = new formEntity();
        $form->setId('forgottenPassword');
        $form->setMethod('post');
        $form->setActionUrl(Routes::getRoutePattern('user.forgot-password'));
        $form->setSubmitText('Get Reset Link');

        $form->addField((new inputField('email'))->setLabel('Email Address')->setInputType('email')->isRequired());
        $form->addField((new linkField('returnToLogin'))->setLinkType('internal')->addClass('forgottenPasswordLink')->setValue('/login')->setLinkTitle('Return to login'));

        return $form->getBuiltFormArray();
    }
}