<?php

namespace apexl\Io\modules\userDisplay\forms;

use apexl\Io\includes\Routes;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\linkField;

class loginForm {
    public function loginForm() {
        $form = new formEntity();
        $form->setId('login');
        $form->setMethod('post');
        $form->setActionUrl(Routes::getRoutePattern('user.login'));
        $form->setSubmitText('Sign in');
        $form->includeClearButton(TRUE)->setClearButtonText('Cancel');

        $form->addField((new inputField('email'))->setLabel('Email')->setInputType('email')->isRequired());
        $form->addField((new inputField('password'))->setLabel('Password')->setInputType('password')->isRequired());
        $form->addField((new linkField('forgottenPassword'))->setLinkType('internal')->addClass('forgottenPasswordLink')->setValue('/forgot-password')->setLinkTitle('Forgot your password?'));

        return $form->getBuiltFormArray();
    }
}