<?php

namespace apexl\Io\modules\user\classes;

use apexl\Io\includes\Entity;
use apexl\Io\modules\display\controllers\displayController;
use apexl\Io\recommendedIncludes\displayModule;

class userManagedDisplayModule extends displayModule{

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Method to add a route, allows the module to have a base path configured and for easy overrides.
     * This Method adds one extra option over the base, to permissions protect a route.
     * @param $verb
     * @param $name
     * @param string $pattern
     * @param $callable
     * @param $permission
     * @return userManagedDisplayModule
     */
    protected function addProtectedDisplayRoute($verb, $name, string $pattern, $callable, $permission = 'AllowAll'){
        $this->addRoute($verb, $name, 'display/'.ltrim($pattern, '/'), $callable);
        $this->route::addRouteArg($name, 'permission', $permission);
        return $this;
    }

    /**
     * Method to add a route, allows the module to have a base path configured and for easy overrides.
     * This Method adds one extra option over the base, to permissions protect a route.
     * @param $verb
     * @param $name
     * @param string $pattern
     * @param $callable
     * @param $permission
     * @return userManagedDisplayModule
     */
    protected function addProtectedDataRoute($verb, $name, string $pattern, $callable, $permission = 'AllowAll'){
        $this->addRoute($verb, $name, 'display/data/'.ltrim($pattern, '/'), $callable);
        $this->route::addRouteArg($name, 'permission', $permission);
        return $this;
    }

    /**
     * Method to add a route, allows the module to have a base path configured and for easy overrides.
     * This Method adds one extra option over the base, to permissions protect a route.
     * @param $name
     * @param string $pattern
     * @param $callable
     * @param $permission
     * @return userManagedDisplayModule
     */
    protected function addProtectedFormRoute($name, string $pattern, $callable, $permission = 'AllowAll'){
        $this->addDisplayRoute('GET', $name, 'forms/'.$pattern, $callable);
        $this->route::addRouteArg($name, 'permission', $permission);
        return $this;
    }

    /**
     * Method to add a route, allows the module to have a base path configured and for easy overrides.
     * This Method adds one extra option over the base, to permissions protect a route.
     * @param $entity
     * @param string $pattern
     * @param $callable
     * @param string $permission
     * @return userManagedDisplayModule
     */
    protected function addProtectedEntityFormRoute($entity, string $pattern, $callable, $permission = 'AllowAll'){
        $this->addDisplayRoute('GET', $entity->getEntityName().'.entity.form.createUpdate', 'forms/entities/'.$this->getName().'/'.$pattern, $callable);
        $this->route::addRouteArg($entity->getEntityName().'.entity.form.createUpdate', 'permission', $permission);
        $this->route::addRouteArg($entity->getEntityName().'.entity.form.createUpdate', 'entity', get_class($entity));
        return $this;
    }

    /**
     * Method to add a route, allows the module to have a base path configured and for easy overrides.
     * This Method adds one extra option over the base, to permissions protect a route.
     * @param $verb
     * @param $name
     * @param string $pattern
     * @param $callable
     * @param $permission
     * @return userManagedDisplayModule
     */
    protected function addProtectedRootRoute($verb, $name, string $pattern, $callable, $permission = 'AllowAll'){
        $this->rootRoute($verb, $name, $pattern, $callable);
        $this->route::addRouteArg($name, 'permission', $permission);
        return $this;
    }

    /**
     * @param $verb
     * @param $name
     * @param string $pattern
     * @param $callable
     * @param string $permission
     * @return $this
     */
    protected function addProtectedAdminRootRoute($verb, $name, string $pattern, $callable, $permission = 'AllowAll'){
        $this->rootRoute($verb, $name, 'admin/'.$pattern, $callable);
        $this->route::addRouteArg($name, 'permission', $permission);
        return $this;
    }

    /**
     * Declare intention to build routes for this entity. Will take defaults if not previously defined.
     * @param Entity $entity
     * @param null $callables
     * @param null $patterns
     * @return $this
     */
    protected function addProtectedEntityRoutes(Entity $entity, $callables = NULL, $patterns = []){
        $this->setEntityPatterns($entity, $patterns);

        foreach($this->entityPatterns[$entity->getEntityName()] as $verb => $pattern){
            if (isset($callables[$verb]) && is_array($callables[$verb])) {
                $this->setEntityCallable($entity, $verb, ($callables[$verb][0] ?? displayController::class.':'.$verb));
            }
        }

        //build the routes.
        $this->buildEntityRoutes($entity, TRUE);
        //protect the built routes
        foreach($this->entityPatterns[$entity->getEntityName()] as $verb => $pattern){
            $this->route::addRouteArg($entity->getEntityName().'.display.'.strtolower($verb), 'permission', $callables[$verb][1] ?? 'AllowAll');
            $this->route::addRouteArg($entity->getEntityName().'.display.'.strtolower($verb), 'entity', get_class($entity));
        }
        return $this;
    }

    /**
     * @param $entity
     * @param array $patterns
     * @return $this|userManagedDisplayModule
     */
    protected function setEntityPatterns($entity, array $patterns = []){
        $this->defaultEntityPatterns = [
            'all' => '/list', //Root display pattern, by default load all entities
            'post' => '/create', //no pattern here as we should POST to the base entity path (by default)
            'put' => '/{'.$entity->primaryKey.'}/edit',
            'delete' => '/{'.$entity->primaryKey.'}/delete',
            'get' => '[/{'.$entity->primaryKey.'}]',
        ];
        $this->patternsOverridden = !empty($patterns);
        $this->entityPatterns[$entity->getEntityName()] = array_merge($this->defaultEntityPatterns, $patterns);
        return $this;
    }

    /**
     * Normal structure is /ModuleName/EntityName/{pattern}
     * Build any default entity routes.
     * @param $entity
     * @param bool $rootRouts
     */
    protected function buildEntityRoutes($entity, $rootRouts = FALSE){
        $method = $rootRouts ? 'rootRoute' : 'addRoute';
        foreach($this->entityPatterns[$entity->getEntityName()] as $verb => $pattern){
            if(isset($this->entityControllers[$entity->getEntityName()][$verb])) {
                $basePattern = $this->patternsOverridden ? '' : (str_replace('entity', '', strtolower($entity->getEntityName())));
                $this->$method(
                    "GET", //Always Get for display.
                    $entity->getEntityName().'.display.'.strtolower($verb),
                    $basePattern.$pattern,
                    $this->entityControllers[$entity->getEntityName()][$verb]
                );
            }
        }
    }
}
