<?php

namespace apexl\Io\modules\user\services;

use apexl\ClassEngine\EngineSingleton;

class Permissions extends EngineSingleton{
    protected $permissions;

    public function registerPermission($permission, $friendlyName, $group = 'General'){
        $this->permissions[$permission] = (object)['name' => $friendlyName, 'group' => $group];
    }

    public function getPermission($permission){
        if($permission) {
            return $this->permissions[$permission] ?? FALSE;
        } else {
            return FALSE;
        }
    }

    public function getPermissions(){
        return $this->permissions;
    }
}