<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\ValidationRules;

use ReflectionClass;
use Stringy\Stringy;

abstract readonly class ValidationRule
{
    public string $name;

    public function __construct(
        public string $config = '',
    ) {
        $this->name = defined('static::NAME') ?
            static::NAME :
            Stringy::create(new ReflectionClass($this)->getShortName())->snakeCase()->toLowerCase()->toString();
    }

    public function toString(): string
    {
        return sprintf('%s%s', $this->name, $this->config ? sprintf(':%s', $this->config) : '');
    }


    public function toValidatorString(): string
    {
        return $this->toString();
    }

    public function toFormKitValidatorString(): string
    {
        return $this->toString();
    }
}