<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\Services;

use apexl\Io\modules\validation\Collections\ValidationRuleCollectionCollection;
use apexl\Io\modules\validation\Exceptions\ValidationException;
use apexl\Io\modules\validation\Factories\ValidatorFactory;

final readonly class Validator
{
    public function __construct(private ValidatorFactory $validatorFactory) {}

    /**
     * @throws ValidationException
     */
    public function validate(array $data, ValidationRuleCollectionCollection $rules): void
    {
        $validator = $this->validatorFactory->make($data, $rules->forValidator());

        if (!$validator->isValid()) {
            throw new ValidationException();
        }
    }
}
