<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\Factories;

use apexl\Io\modules\validation\ValidationRules\ValidationRule;
use DI\Container;
use function apexl\Io\assertInstanceOf;

final readonly class ValidationRuleFactory
{
    public function __construct(
        private Container $container,
    ) {}

    /**
     * @param class-string<ValidationRule> $class
     */
    public function make(string $class, string $config): ValidationRule
    {
        assertInstanceOf($class, ValidationRule::class);

        return $this->container->make($class, ['config' => $config]);
    }

}