<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\Collections;

use apexl\Io\modules\validation\ValidationRules\ValidationRule;
use Arrayy\Collection\AbstractCollection;
use Arrayy\Type\TypeInterface;

final class ValidationRuleCollection extends AbstractCollection implements TypeInterface
{

    public function getType(): string
    {
        return ValidationRule::class;
    }

    public function toFormKitString(): string
    {
        return $this->map(fn(ValidationRule $validation): string => $validation->toFormKitValidatorString())
            ->implode('|');
    }

    public function toValidationString(): string
    {
        return $this->map(fn(ValidationRule $validation): string => $validation->toValidatorString())
            ->implode('|');
    }
}