<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\Factories;

use BlakvGhost\PHPValidator\Validator;
use DI\Container;

final readonly class ValidatorFactory
{
    private const string DEFAULT_LANG = 'en';

    public function __construct(
        private Container $container,
    ) {}

    public function make(array $data, array $rules, array $messages = [], ?string $lang = self::DEFAULT_LANG): Validator
    {
        return $this->container->make(Validator::class, [
            'data' => $data,
            'rules' => $rules,
            'messages' => $messages,
            'lang' => $lang ?? self::DEFAULT_LANG,
        ]);
    }

}