<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\Hooks;

use apexl\Io\interfaces\AbstractHook;
use apexl\Io\modules\system\services\WhoopsHandlerCollector;
use apexl\Io\modules\validation\WhoopsHandlers\WhoopsValidationHandler;

class AddWhoopsValidationHandler implements AbstractHook
{
    public function __construct(
        private WhoopsValidationHandler $whoopsValidationHandler,
    ) {}

    public function hooks(): array
    {
        return [WhoopsHandlerCollector::HOOK__COLLECT];
    }

    public function __invoke(array $handlers): array
    {
        $handlers[] = $this->whoopsValidationHandler;

        return $handlers;
    }
}