<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\Services;
;

use apexl\Io\modules\validation\Collections\ValidationRuleCollectionCollection;
use apexl\Io\modules\validation\Interfaces\HasValidationRulesInterface;

final readonly class ValidationRuleCollector
{
    public function collect(HasValidationRulesInterface $hasValidationRules): ValidationRuleCollectionCollection
    {
        return $hasValidationRules->getValidationRules(new ValidationRuleCollectionCollection());
    }
}