<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\Traits;

use apexl\Io\enums\HttpMethod;
use apexl\Io\Request\IoRequest;
use Slim\Routing\Route;
use Slim\Routing\RouteContext;

trait ValidatesData
{
    public function dataToValidate(): array
    {
        /** @noinspection PhpInstanceofIsAlwaysTrueInspection */
        if ($this instanceof IoRequest) {
            $requestData = $this->ioRequestData();
            $routeArgs = $this->getAttribute(RouteContext::ROUTE)->getArguments();

            return [
                ...$requestData,
                ...$routeArgs
            ];
        }

        return [];
    }

    private function ioRequestData(): array
    {
        /** @var Route $route */

        if ($this->isMethod(
            HTTPMethod::POST,
            HTTPMethod::PUT,
            HTTPMethod::PATCH,
        )) {
            return $this->getParsedBody() ?? [];
        }

        return $this->getQueryParams();
    }

    public function validationMessages(): array
    {
        return [];
    }

    public function validationLang(): ?string
    {
        return null;
    }
}